--  usage: add a line like 
-- 
-- dofile("d:\\prj\\util\\wireshark-dissectors\\abms.lua")
--  or 
-- dofile("c:\\vision\\bin\\wireshark-dissectors\\abms.lua")
--
--  to the end of Wireshark's init.lua file, which is typically 
--
-- c:\Program Files\Wireshark\init.lua 
--
-- to enable LUA in Wireshark comment out the first line after the initial comments of init.lua
--
-- To enter the ports and byte order you use, from the Wireshark menu:
-- open Edit/Preferences and select Protocols/ABMS

do
	local p_abms = Proto("abms","alpha-bit Master-Slave Syncronization")
	
	local f_AbMS = ProtoField.string("abms.abms","AbMS")
	local f_Type = ProtoField.string("abms.type","Type")
	local f_Priority = ProtoField.int32("abms.priority","Priority",base.DEC)
	
	p_abms.prefs["ports"] = Pref.string("Ports", "", "Example: '3000-3009, 3050, 3051, 3080-3089'")
	p_abms.prefs["priority_network_byteorder"] = Pref.bool("Priority has network byte order", true, "uncheck for versions < 9.21")
	 
	p_abms.fields = { 
		f_AbMS, 
		f_Type, 
		f_Priority, 
		}
		
	function p_abms.dissector(buf,pkt,root) 
		local t_abms = root:add(p_abms,buf(0,-1))
		t_kenn = t_abms:add(f_AbMS,buf(0,4))
		if buf(0,4):string() ~= "AbMS" then
			t_kenn:append_text(" (Identification 'AbMS' is missing, probably another protocol or wrong port)")
			t_kenn:set_expert_flags(PI_MALFORMED, PI_WARN)
			t_abms:set_expert_flags(PI_MALFORMED, PI_WARN)
		end
		t_type = t_abms:add(f_Type,buf(4,4))
		if buf(4,4):string() ~= "MREQ" and buf(4,4):string() ~= "INFO" then
			t_type:append_text(" (Valid types are 'MREQ' and 'INFO')")
			t_type:set_expert_flags(PI_MALFORMED, PI_WARN)
			t_abms:set_expert_flags(PI_MALFORMED, PI_WARN)
		end
		if p_abms.prefs.priority_network_byteorder then
			t_abms:add(f_Priority,buf(8,4))
		else
			t_prio = t_abms:add(buf(8,4), "Priority")
			local prio = (((buf(11,1):uint()*256)+buf(10,1):uint())*256+buf(9,1):uint())*256+buf(8,1):uint()
			if prio == 0xffffffff then
				t_prio:set_text("Priority: -1")
			else		
				t_prio:set_text("Priority: "..tostring(prio))
			end
		end
	end
	
	
	function p_abms.init()
		if p_abms.prefs.ports ~= "" then
			local udp_encap_table = DissectorTable.get("udp.port")
			local ports = p_abms.prefs.ports
			for range in string.gmatch(ports, "%s*([^,]*)%s*") do
				portFrom,portTo = string.match(range, "%s*(%d*)%s*\-%s*(%d*)%s*")
				if portFrom and portTo then
					for port = tonumber(portFrom), tonumber(portTo), 1 do
						udp_encap_table:add(tonumber(port),p_abms)
					end
				elseif range and tonumber(range) then
					udp_encap_table:add(tonumber(range),p_abms)
				end		       
			end
		end
	end
end
