--  usage: add a line like 
-- 
-- dofile("d:\\prj\\util\\wireshark-dissectors\\udp2av.lua")
--  or 
-- dofile("c:\\vision\\bin\\wireshark-dissectors\\udp2av.lua")
--
--  to the end of Wireshark's init.lua file, which is typically 
--
-- c:\Program Files\Wireshark\init.lua 
--
-- to enable LUA in Wireshark comment out the first line after the initial comments of init.lua
--
-- To enter the ports you use, from the Wireshark menu:
-- open Edit/Preferences and select Protocols/UDP2AV

do
	local p_udp2av_os2os = Proto("udp2av_os2os","alpha-bit Udp2Av OS to OS")
	
	local ePacketTypes = {
		[0] = "NORMAL",
		[1] = "ROLLBACK",
		[2] = "LIFESIGN",
		[3] = "PACKETIDTOOLOW",
	}
	OSTELE_KIND_OLDPLUGIN = 1
	OSTELE_KIND_ALARMACKN = 2
	OSTELE_KIND_GA = 3
	
	RELIABLE_HDR_LEN = 24
	
	local eTgrName = {
		[OSTELE_KIND_OLDPLUGIN] = "OSTELE_KIND_OLDPLUGIN",
		[OSTELE_KIND_ALARMACKN] = "OSTELE_KIND_ALARMACKN",
		[OSTELE_KIND_GA] = "OSTELE_KIND_GA",
	}
	
	local eTgrDescr = {
		[OSTELE_KIND_OLDPLUGIN] = "plugin message",
		[OSTELE_KIND_ALARMACKN] = "alarm acknowledge (OS -> OS)",
		[OSTELE_KIND_GA] = "query all values and states (OS -> OS)",
	}
	
	local eRecLen = {
		[DATE_TIME] = 12,
		[REPORT_HIGH] = 8,
		[VALUES_HIGH] = 6,
		[CONTROL_STATE] = 4,
		[FADE] = 4,
		[RECEIPT_ALARM] = 2,
		[DYN_LIMIT] = 8,
		[IMA_PARAMS] = 12,
		[GENERAL_QUERY] = 2,
		[PO_STRING] = 4,
		[CONTROL_VALUE] = 6,
	}
	
	local eLimitSign = {
		[0] = "OLD",
		[1] = "DELAY (delay entries are valid)",
		[2] = "VAL (limit ('Val') entry is valid)",
		[3] = "BOTH (all entries are valid)"
	}
	
	local f_SenderId = ProtoField.int32("udp2av_os2os.SenderId","SenderId",base.DEC)
	local f_PacketId = ProtoField.int32("udp2av_os2os.PacketId","PacketId",base.DEC)
	local f_ReceiverId = ProtoField.int32("udp2av_os2os.ReceiverId","ReceiverId",base.DEC)
	local f_PacketType = ProtoField.int32("udp2av_os2os.PacketType","PacketType",base.DEC,ePacketTypes)
	local f_TotalPacketLength = ProtoField.int32("udp2av_os2os.TotalPacketLength","TotalPacketLength",base.DEC)
	local f_PartialPacketId = ProtoField.int32("udp2av_os2os.PartialPacketId","PartialPacketId",base.DEC)
	local f_RollbackReqId = ProtoField.int32("udp2av_os2os.RollbackReqId","RollbackReqId",base.DEC)
	
	local f_TgrType = ProtoField.uint32("udp2av_os2os.TgrType","TgrType (OS->OS telegram type)",base.DEC,eTgrName)
	local f_UnknownTgrType = ProtoField.uint32("udp2av_os2os.UnknownTgrType","UnknownTgrType (OS->OS telegram type)")
	
	p_udp2av_os2os.prefs["ports"] = Pref.string("UDP-Ports", "", "Example: '3000-3009, 3050, 3051, 3080-3089'")
	
	p_udp2av_os2os.fields = { 
		f_SenderId, 
		f_PacketId, 
		f_ReceiverId, 
		f_PacketType, 
		f_TotalPacketLength, 
		f_PartialPacketId, 
		f_RollbackReqId, 
		
		f_TgrType, 
		f_UnknownTgrType, 
		}
		
	function p_udp2av_os2os.dissector(buf,pkt,root) 
		local t_udp2av = root:add(p_udp2av_os2os,buf(0,-1))
		t_udp2av:add(f_SenderId,buf(0,4))
		t_udp2av:add(f_PacketId,buf(4,4))
		t_udp2av:add(f_ReceiverId,buf(8,4))
		t_udp2av:add(f_PacketType,buf(12,4))
		t_udp2av:add(f_TotalPacketLength,buf(16,4))
		t_udp2av:add(f_PartialPacketId,buf(20,4))
		if buf(12,4):uint() == 1 then --rollback request
			if buf(16,4):uint() ~= 4 then 
				t_udp2av:set_expert_flags(PI_MALFORMED, PI_WARN)
				t_udp2av:append_text("rollback requests must have 4 bytes of rollback req. id")
			else
				t_udp2av:add(f_RollbackReqId,buf(24,4))
			end
		elseif buf(16,4):uint() > 0 and buf:len() == buf(16,4):uint() + 24 then
			posTgrType = 24
			kind = buf(posTgrType,4):uint()
			if		kind == OSTELE_KIND_OLDPLUGIN
				or	kind == OSTELE_KIND_ALARMACKN
				or	kind == OSTELE_KIND_GA
					then 
				t_udp2av:add(f_TgrType,buf(posTgrType,4))
			else
				t_udp2av:add(f_UnknownTgrType,buf(posTgrType,4))
			end
		end
	end
	
	function p_udp2av_os2os.init()
		if p_udp2av_os2os.prefs.ports ~= "" then
			local udp_encap_table = DissectorTable.get("udp.port")
			local ports = p_udp2av_os2os.prefs.ports
			for range in string.gmatch(ports, "%s*([^,]*)%s*") do
				portFrom,portTo = string.match(range, "%s*(%d*)%s*\-%s*(%d*)%s*")
				if portFrom and portTo then
					for port = tonumber(portFrom), tonumber(portTo), 1 do
						udp_encap_table:add(tonumber(port),p_udp2av_os2os)
					end
				elseif range and tonumber(range) then
					udp_encap_table:add(tonumber(range),p_udp2av_os2os)
				end		       
			end
		end
	end
end
