<?xml version="1.0"?>

<!-- Generic stylesheet for viewing XML -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

	<!-- This template will always be executed, even if this stylesheet is not run on the document root -->
	<xsl:template match="/">
		<html>
		<head>
		</head>
			<xsl:apply-templates/>
		<body>
		</body>
		</html>
	</xsl:template>

<xsl:template match = "Value">
	<xsl:value-of select="@Value"/>
</xsl:template>

<xsl:template match = "Members">
	<xsl:apply-templates select="Symbol"/>
</xsl:template>

<xsl:template match = "ESSymbolDescr">
	<TD width="100pt"><xsl:value-of select="@TypeSpec"/></TD>
</xsl:template>

<xsl:template match = "Symbol">
	<TR><TD max-width="100pt"><font size="4"><xsl:value-of select="@Name"/></font></TD>
		<TD width="150pt"><xsl:apply-templates select="Value"/></TD>
		<xsl:apply-templates select="ESSymbolDescr"/></TR>
	<xsl:apply-templates select="Members"/>
</xsl:template>

<xsl:template match = "Default_Symbols">
	<font face="Arial Black" size="3">Default_Symbols</font><p/>
	<TABLE STYLE="border:1px solid black" border="2">
		<TR><TD max-width="100pt"><font size="4">Symbol</font></TD>
	<TD width="150pt"><font size="4">Actual Value</font></TD>
	<TD width="100pt"><font size="4">Type</font></TD></TR>
		<xsl:apply-templates select="Symbol"/>
	</TABLE><p/>
</xsl:template>

<xsl:template match = "IOs">
	<font face="Arial Black" size="3">IOs</font><p/>
	<TABLE STYLE="border:1px solid black" border="2">
		<TR><TD max-width="100pt"><font size="4">Symbol</font></TD>
	<TD width="150pt"><font size="4">Actual Value</font></TD>
	<TD width="100pt"><font size="4">Type</font></TD></TR>
		<xsl:apply-templates select="Symbol"/>
	</TABLE><p/>
</xsl:template>

<xsl:template match = "Interfaces">
	<font face="Arial Black" size="3">Interfaces</font><p/>
	<TABLE STYLE="border:1px solid black" border="2">
		<TR><TD max-width="100pt"><font size="4">Symbol</font></TD>
	<TD width="150pt"><font size="4">Actual Value</font></TD>
	<TD width="100pt"><font size="4">Type</font></TD></TR>
		<xsl:apply-templates select="Symbol"/>
	</TABLE><p/>
</xsl:template>

<xsl:template match = "ISymbol">
		<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "Configuration">
	Description: <font size="4"><xsl:value-of select="@Description"/></font><p/>
	Configuration: <xsl:value-of select="@Configuration"/><p/>
	<p/>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "IConfig">
	<font face="Arial Black" size="3">Configuration</font><p/>
	<xsl:apply-templates select="Configuration"/>
	<TABLE STYLE="border:1px solid black" border="2">
		<TR><TD max-width="100pt"><font size="4">Symbol</font></TD>
	<TD width="150pt"><font size="4">Actual Value</font></TD>
	<TD width="100pt"><font size="4">Type</font></TD></TR>
		<xsl:apply-templates select="Symbol"/>
	</TABLE><p/>
</xsl:template>

<xsl:template match="IPhysDimUnits"><font face="Arial Black" size="5">IPhysDimUnits:</font><p/>
	<TABLE STYLE="border:1px solid black" border="2">
	<TR>
		<TD width="150pt"><font size="4">PhysDim</font></TD>
		<TD width="50pt"><font size="4">Index</font></TD>
		<TD width="80pt"><font size="4">Unit</font></TD>
		<TD width="50pt"><font size="4">Index</font></TD>
	</TR>
	<xsl:for-each select="PhysDim">
	<TR>
		<TD width="150pt"><xsl:apply-templates select="Name"/></TD>
		<TD width="50pt"><xsl:value-of select="@Index"/></TD>
		<xsl:apply-templates select="Unit"/>
	</TR>
	</xsl:for-each>
	</TABLE><p/>
</xsl:template>

<xsl:template match="Unit">
	<TD width="80pt"><xsl:apply-templates select="Name"/></TD>
	<TD width="50pt"><xsl:value-of select="@Index"/></TD>
</xsl:template>
<xsl:template match="Name">
	<xsl:value-of/>
</xsl:template>

<xsl:template match="ILibContainer"><font face="Arial Black" size="5">ILibContainer:</font><p/>
	<xsl:apply-templates select="DeviceType"/>
</xsl:template>

<xsl:template match="DeviceType">
	<TABLE STYLE="border:1px solid black" border="2">
		<TR>
			<TD><font size="4">DeviceType:</font></TD>
			<TD><xsl:value-of select="@GUID"/></TD>
		</TR>
		<xsl:for-each select= "PackageType">
		<TR>
			<TD>PackageType:</TD>
			<TD><xsl:value-of select="@GUID"/></TD>
		</TR>
		</xsl:for-each>
	</TABLE><p/>
</xsl:template>

<xsl:template match = "Point">
	<TR><TD>Point:</TD>
	<TD>Change:</TD>
	<TD><xsl:value-of select="@Change"/> </TD></TR>
	<TR><TD></TD><TD>DefRange:</TD>
	<TD><xsl:value-of select="@DefRange"/> </TD></TR>
	<TR><TD></TD><TD>ValueRange:</TD>
	<TD><xsl:value-of select="@ValueRange"/> </TD></TR>
</xsl:template>

<xsl:template match = "coefficients">
	<TR><TD>coefficients:</TD>
	<TD>Degree:</TD>
	<TD><xsl:value-of select="@Degree"/> </TD></TR>
	<TR><TD></TD><TD>coeff0:</TD>
	<TD><xsl:value-of select="@coeff0"/> </TD></TR>
	<TR><TD></TD><TD>coeff1:</TD>
	<TD><xsl:value-of select="@coeff1"/> </TD></TR>
	<TR><TD></TD><TD>coeff2:</TD>
	<TD><xsl:value-of select="@coeff2"/> </TD></TR>
	<TR><TD></TD><TD>coeff3:</TD>
	<TD><xsl:value-of select="@coeff3"/> </TD></TR>
	<TR><TD></TD><TD>coeff4:</TD>
	<TD><xsl:value-of select="@coeff4"/> </TD></TR>
	<TR><TD></TD><TD>coeff5:</TD>
	<TD><xsl:value-of select="@coeff5"/> </TD></TR>
	<TR><TD></TD><TD>coeff6:</TD>
	<TD><xsl:value-of select="@coeff6"/> </TD></TR>
</xsl:template>

<xsl:template match = "Sinus">
	<TR><TD>Sinus:</TD>
	<TD>SinB:</TD>
	<TD><xsl:value-of select="@SinB"/> </TD></TR>
	<TR><TD></TD><TD>SinC:</TD>
	<TD><xsl:value-of select="@SinC"/> </TD></TR>
	<TR><TD></TD><TD>SinD:</TD>
	<TD><xsl:value-of select="@SinD"/> </TD></TR>
</xsl:template>

<xsl:template match = "Normalform">
	<TR><TD>Normalform:</TD>
	<TD>End:</TD>
	<TD><xsl:value-of select="@End"/> </TD></TR>
	<TR><TD></TD><TD>Start:</TD>
	<TD><xsl:value-of select="@Start"/> </TD></TR>
</xsl:template>

<xsl:template match = "DefRange">
	<TR><TD>DefRange:</TD>
	<TD>End:</TD>
	<TD><xsl:value-of select="@End"/> </TD></TR>
	<TR><TD></TD><TD>Start:</TD>
	<TD><xsl:value-of select="@Start"/> </TD></TR>
</xsl:template>

<xsl:template match = "ValueRange">
	<TR><TD>ValueRange:</TD>
	<TD>End:</TD>
	<TD><xsl:value-of select="@End"/> </TD></TR>
	<TR><TD></TD><TD>Start:</TD>
	<TD><xsl:value-of select="@Start"/> </TD></TR>
</xsl:template>

<xsl:template match = "linTransformation">
	<TR><TD>linTransformation:</TD></TR>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "Scale">
	<TR><TD></TD><TD>ScaleTo:</TD>
	<TD><xsl:value-of select="@ScaleTo"/> </TD></TR>
	<TR><TD></TD><TD>ScaleFrom:</TD>
	<TD><xsl:value-of select="@ScaleFrom"/> </TD></TR>
	<TR><TD></TD><TD>ScaleFactor:</TD>
	<TD><xsl:value-of select="@ScaleFactor"/> </TD></TR>
</xsl:template>

<xsl:template match = "CAM_Type">
	<TR><TD>CAM_Type:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "Start">
	<TR><TD>Start:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "End">
	<TR><TD>End:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "Starttype">
	<TR><TD>Starttype:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "Endtype">
	<TR><TD>Endtype:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "Ordercriteria">
	<TR><TD>Ordercriteria:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "GeoChanged">
	<TR><TD>GeoChanged:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "ScalingChanged">
	<TR><TD>ScalingChanged:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "min_Difference_DefRange">
	<TR><TD>min_Difference_DefRange:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "max_Difference_DefRange">
	<TR><TD>max_Difference_DefRange:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "min_Difference_ValueRange">
	<TR><TD>min_Difference_ValueRange:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "max_Difference_ValueRange">
	<TR><TD>max_Difference_ValueRange:</TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "PointTable">
	<TR><TD colspan="2"><font size="4">PointTable:</font></TD></TR>
	<xsl:apply-templates select="Point"/>
</xsl:template>

<xsl:template match = "Polynom">
	<TR><TD><font size="4">Polynom:</font></TD>
	<TD>Change:</TD>
	<TD><xsl:value-of select="@Change"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "Shift">
	<TR><TD><font size="4">Shift:</font></TD>
	<TD>Axis:</TD>
	<TD><xsl:value-of select="@Axis"/> </TD></TR>
	<TR><TD></TD><TD>Type:</TD>
	<TD><xsl:value-of select="@Type"/> </TD></TR>
	<TR><TD></TD><TD>Shift:</TD>
	<TD><xsl:value-of select="@Shift"/> </TD></TR>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "Scaling">
	<TR><TD><font size="4">Scaling:</font></TD>
	<TD>Axis:</TD>
	<TD><xsl:value-of select="@Axis"/> </TD></TR>
	<TR><TD></TD><TD>Type:</TD>
	<TD><xsl:value-of select="@Type"/> </TD></TR>
	<TR><TD></TD><TD>Index:</TD>
	<TD><xsl:value-of select="@Index"/> </TD></TR>
	<xsl:apply-templates select="Scale"/>
</xsl:template>

<xsl:template match = "Interpolationtype">
	<TR><TD><font size="4">Interpolationtype:</font></TD>
	<TD><xsl:value-of/> </TD></TR>
	<TR><TD></TD><TD>VarType:</TD>
	<TD><xsl:value-of select="@VarType"/> </TD></TR>
	<TR><TD></TD><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
</xsl:template>

<xsl:template match = "Correctioninterpolation">
	<TR><TD colspan="2"><font size="4">Correctioninterpolation:</font></TD></TR>
	<TR><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "Control">
	<TR><TD colspan="2"><font size="4">Control:</font></TD></TR>
	<TR><TD valign="top">Comment:</TD>
	<TD><xsl:value-of select="@Comment"/> </TD></TR>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "CAM_Header_Data">
	<TR><TD colspan="2"><font size="4">CAM_Header_Data:</font></TD></TR>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "CamData">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match = "ITOCam">
	<font face="Arial Black" size="5">ITOCam	</font><p/>
	<TABLE STYLE="border:1px solid black" border="2">
	<xsl:apply-templates/>
	</TABLE>
</xsl:template>

<xsl:template match="ObjMetaData"><font face="Arial Black" size="5">ObjMetaData:</font><p/>
	<TABLE STYLE="border:1px solid black" border="2">
		<xsl:apply-templates select="ActualSnapIn"/>
		<xsl:apply-templates select="Flag"/>
		<xsl:apply-templates select="LogicalAddress"/>
		<xsl:apply-templates select="S7OD"/>
	</TABLE><p/>
	<font face="Arial Black" size="3">Author:</font><p/>
	<xsl:value-of select="Author"/>
	<p/>
	<font face="Arial Black" size="3">Version:</font><p/>
	<xsl:value-of select="Version"/>
	<p/>
	<font face="Arial Black" size="3">Comment:</font><p/>
	<xsl:value-of select="Comment"/>
	<p/>
</xsl:template>

<xsl:template match="ActualSnapIn">
	<TR>
		<TD><font size="4">ActualSnapIn:</font></TD>
	</TR>
	<TR>
		<TD>GUID:</TD>
		<TD><xsl:value-of select="@GUID"/></TD>
	</TR>
</xsl:template>
<xsl:template match="Flag">
	<TR>
		<TD><font size="4">Flag:</font></TD>
		<TD><xsl:value-of select="@Name"/></TD>
	</TR>
	<TR>
		<TD>Flags:</TD>
		<TD><xsl:value-of select="@Flags"/></TD>
	</TR>
</xsl:template>
<xsl:template match="LogicalAddress">
	<TR>
		<TD><font size="4">LogicalAddress:</font></TD>
	</TR>
	<TR>
		<TD>DeviceAddress:</TD>
		<TD><xsl:value-of select="@DeviceAddress"/></TD>
	</TR>
	<TR>
		<TD>TObjectAddress:</TD>
		<TD><xsl:value-of select="@TObjectAddress"/></TD>
	</TR>
</xsl:template>
<xsl:template match="S7OD">
	<TR>
		<TD><font size="4">S7OD:</font></TD>
	</TR>
	<TR>
		<TD>EnvID:</TD>
		<TD><xsl:value-of select="@EnvID"/></TD>
	</TR>
	<TR>
		<TD>UnitID:</TD>
		<TD><xsl:value-of select="@UnitID"/></TD>
	</TR>
	<TR>
		<TD>EnvType:</TD>
		<TD><xsl:value-of select="@EnvType"/></TD>
	</TR>
	<TR>
		<TD>ObjectID:</TD>
		<TD><xsl:value-of select="@ObjectID"/></TD>
	</TR>
	<TR>
		<TD>UnitType:</TD>
		<TD><xsl:value-of select="@UnitType"/></TD>
	</TR>
	<TR>
		<TD>ObjectType:</TD>
		<TD><xsl:value-of select="@ObjectType"/></TD>
	</TR>
</xsl:template>

<xsl:template match="ISATopologyNavigate"><xsl:apply-templates/>
</xsl:template>

<xsl:template match="SATopology"><font face="Arial Black" size="5">SATopology</font><p/>
	Type: <xsl:value-of select="@Type"/><p/>
	MasterDeviceID: <xsl:value-of select="@MasterDeviceID"/><p/>
	<xsl:apply-templates select="SAComponents"/>
	<xsl:apply-templates select="SAConnections"/>
</xsl:template>

<xsl:template match="SAComponents">
	<font size="4">SAComponents</font>
	<TABLE STYLE="border:1px solid black" border="2">
	<xsl:for-each select="SAComponentBox">
		<TR>
			<TD><font size="4"><xsl:value-of select="@Name"/></font></TD>
			<TD><font size="4">MLFB:</font></TD>
			<TD colspan="4"><font size="4"><xsl:value-of select="@MLFB"/></font></TD>
		</TR>
		<TR>
			<TD>DeviceID:</TD>
			<TD>Name:</TD>
			<TD>DeviceType:</TD>
			<TD>NodeID.Index:</TD>
			<TD>IsActive:</TD>
			</TR>
		<xsl:for-each select="SAComponent">
			<TR>
				<TD><xsl:value-of select="@DeviceID"/></TD>
				<TD><xsl:value-of select="@Name"/></TD>
				<xsl:apply-templates select="SANodeID"/>
				<TD><xsl:value-of select="@IsActive"/></TD>
			</TR>
		</xsl:for-each>
	</xsl:for-each>
	</TABLE><p/>
</xsl:template>
<xsl:template match="SANodeID">
				<TD><xsl:value-of select="@DeviceType"/></TD>
				<TD><xsl:value-of select="@NodeID.Index"/></TD>
</xsl:template>
<xsl:template match="SAConnections">
	<font size="4">SAConnections</font>
	<TABLE STYLE="border:1px solid black" border="2">
		<TR>
			<TD>SrcDeviceID</TD>
			<TD>SrcPortID</TD>
			<TD>TargetDeviceID</TD>
			<TD>TargetPortID</TD>
		</TR>
	<xsl:for-each select="SAConnection">
		<TR>
			<TD><xsl:value-of select="@SrcDeviceID"/></TD>
			<TD><xsl:value-of select="@SrcPortID"/></TD>
			<TD><xsl:value-of select="@TargetDeviceID"/></TD>
			<TD><xsl:value-of select="@TargetPortID"/></TD>
		</TR>
	</xsl:for-each>
	</TABLE><p/>
</xsl:template>

</xsl:stylesheet>
